//
// $Id: fmcdrom.h,v 1.8 2001/07/13 15:15:06 nishi Exp $
//
// Copyright (C) 2001 Shouhei Nishi.
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE.
//





#if BX_USE_FMCD_SMF
#  define BX_FMCDROM_SMF  static
#  define BX_FMCDROM_THIS bx_fmcdrom.
#else
#  define BX_FMCDROM_SMF
#  define BX_FMCDROM_THIS this->
#endif

class LOWLEVEL_CDROM;

#ifdef LOWLEVEL_CDROM
#  include "cdrom.h"
#endif

class bx_fmcdrom_c : public logfunctions {
public:
  bx_fmcdrom_c(void);
  ~bx_fmcdrom_c(void);

  BX_FMCDROM_SMF void init(bx_devices_c *);
  BX_FMCDROM_SMF void dma_write(Bit8u *data_byte);
  BX_FMCDROM_SMF void dma_read(Bit8u *data_byte);

#ifdef LOWLEVEL_CDROM
  LOWLEVEL_CDROM* cd;
#endif
  Boolean indisc;
  uint32 capacity;
  int next_lba;
  int last_lba;
  int readindex;
  Bit8u buffer[2048];

  Boolean irq9_raising;
  Boolean irq_from_submpu;
  Boolean irq_end_dma;
  Boolean enable_irq_from_submpu;
  Boolean enable_irq_end_dma;
  Boolean soft_trans;
  Boolean dma_trans;
  Boolean status_read_request;
  Boolean ready;

  int     timer_handle;

  struct {
    Boolean type;
    Boolean irq;
    Boolean status;
    Bit8u   code;
  } command;

  Bit8u    parameter[8];
  Bit8u    status[4];
  unsigned scount;
  unsigned extra_status_count;
  unsigned extra_status_exist;

  Boolean soft_trans_mode;
  Boolean dma_trans_mode;

private:
  bx_devices_c *devices;

  static Bit32u read_handler(void *this_ptr, Bit32u address, unsigned io_len);
  static void   write_handler(void *this_ptr, Bit32u address, Bit32u value, unsigned io_len);
#if !BX_USE_FMCD_SMF
  Bit32u read(Bit32u address, unsigned io_len);
  void   write(Bit32u address, Bit32u value, unsigned len);
#endif
  BX_FMCDROM_SMF void update_irq(void);
  BX_FMCDROM_SMF void update_dma(void);
  BX_FMCDROM_SMF void update_status(Bit8u st0, Bit8u st1, Bit8u st2, Bit8u st3);
  static void   timer_handler(void *);
  BX_FMCDROM_SMF void timer(void);
  };


extern bx_fmcdrom_c bx_fmcdrom;
